﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.Model;
using System.Data;

namespace IndianHealthService.BMXNet.Desktop
{
    public class DesktopPatientContext : DesktopObject, PatientContext
    {



        internal static DesktopPatientContext CreateFrom(DesktopSession aSession)
        {
            DesktopPatientContext answer = new DesktopPatientContext();


            return answer;
        }


        #region PatientContext Members

        public event EventHandler<ContextChangedArgs> Changed;

        public event EventHandler<ContextChangingArgs> Changing;




        public bool HasPatient
        {
            get { return this.Patient != null; }
        }

        public bool HasEncounter
        {
            get { return this.Encounter != null; }
        }

        #endregion


        private User _user = null;

        public User User
        {
            get { return _user; }
            set { _user = value; }
        }


        Patient _patient = null;


        private Encounter _encounter = null;

        public Encounter Encounter
        {
            get { return _encounter; }
        }

        public Patient Patient
        {
            get { return _patient; }
        }

        public bool ChangePatient(Patient aPatient, bool force)
        {
            if (this.Changing != null)
            {
                ContextChangingArgs args = new ContextChangingArgs();
                args.IsPatientChange = true;
                args.Cancel = false;
                args.BeforeContext = this;
                this.Changing.Invoke(this, args);

                if (args.Cancel && (!force))
                {
                    return false;
                }
            }


            this._patient = aPatient;
            this._encounter = null;
            if (this.Changed != null)
            {
                ContextChangedArgs args = new ContextChangedArgs();
                args.IsPatientChange = true;
                args.AfterContext = this;
                this.Changed.Invoke(this, args);
            }
            return true;
        }


        public bool ChangeEncounter(Encounter anEncounter, bool force)
        {
            if (this.Changing != null)
            {
                ContextChangingArgs args = new ContextChangingArgs();
                args.IsVisitChange = true;
                args.Cancel = false;
                args.BeforeContext = this;
                this.Changing.Invoke(this, args);

                if (args.Cancel && (!force))
                {
                    return false;
                }
            }


            this._encounter = anEncounter;
            if (this.Changed != null)
            {
                ContextChangedArgs args = new ContextChangedArgs();
                args.IsVisitChange = true;
                args.AfterContext = this;
                this.Changed.Invoke(this, args);
            }
            return true;
        }


        public bool ChangeEncounter(Encounter aEncounter)
        {
            return this.ChangeEncounter(aEncounter, false);
        }

        public bool ChangePatient(Patient aPatient)
        {
            return this.ChangePatient(aPatient, false);
        }

        public bool AlertAll()
        {
            return this.ChangePatient(this.Patient);
        }

    }
}